
option explicit

mode 1,8

const fw=mm.info(fontwidth)
const fh=mm.info(fontheight)
const lineLen=mm.hres / mm.info(fontwidth)
const bottomrow=mm.vres-fh

dim nullWord$(7) = ("THE","A","AT","ON","IN","TO","WITH","AND")

dim temp$,in$
dim filename$ = "adventure.txt"
'read in the adventure data file and count up how many rooms and objects there are
'input "which adventure file to load";filename$

print:print"loading..."

open filename$ for input as #1

dim endReadLoop,f,totRooms,totObjects,totVerbs,currentRoom,currentObject,currentVerb as integer = 0

'routineNoStack holds the previous routine no. and line no. to go back to
'once current routine has reached end.
dim routineNoStack(10,1)

'-1 is the "end of stack" value
routineNoStack(0,0)=-1

endReadLoop=0
do
  line input #1,temp$
  if instr(temp$,"<ROOM ")<>0 then inc totRooms
  if instr(temp$,"<OBJECT ")<>0 then inc totObjects
  if instr(temp$,"<VERB ")<>0 then inc totVerbs
  if temp$="EOF!" then endReadLoop=1
loop while not endReadLoop

close #1

'set up arrays to the required sizes
dim room$(totRooms-1,5)
'room$ 2nd dimension sub array positions (internal ref is 0)
const action=1
const long=2
const desc=3
const flags=4
const exits=5

dim object$(totObjects-1,9)
'object$ also uses desc (,3) and flags (,4) and action (,1) as room$
const synonym=2
const ldesc=5
const fdesc=6
const location=7
const adjective=8
const size=9

dim verb$(totVerbs-1,2)
'verb$ uses synonym (,2) and action (,1)

'read the file again and store the rooms, objects and verbs in appropriate array
open filename$ for input as #1
endReadLoop=0
do 
readNewLine1:
  line input #1,temp$
  temp$=trim(temp$)
  if left$(temp$,1)=";" then goto readNewLine1:
  if instr(temp$,"<ROOM ")<>0 then
    'add a new room to the room$() array
    addRoom
'    print "Room ";currentRoom
'    print "int. =";room$(currentRoom,0)
'    print "Desc =";room$(currentRoom,desc)
'    print "Flags=";room$(currentRoom,flags)
'    print "Long =";room$(currentRoom,long)
'    print "Exits=";room$(currentRoom,exits)
'    print "action=";room$(currentRoom,action)
'    print
    inc currentRoom
  endif

  if instr(temp$,"<OBJECT ")<>0 then 
    'add a new object to the object$() array
    addObject
'    print "Object ";currentObject
'    print "Int.   =";object$(currentObject,0)
'    print "Desc   =";object$(currentObject,desc)
'    print "FDesc  =";object$(currentObject,fdesc)
'    print "LDesc  =";object$(currentObject,ldesc)
'    print "Loc    =";object$(currentObject,location)
'    print "synonym=";object$(currentObject,synonym)
'    print "adjectv=";object$(currentObject,adjective)
'    print "size   =";object$(currentObject,size)
'    print "flags  =";object$(currentObject,flags)
'    print "action =";object$(currentObject,action)
   ' print
    inc currentObject
  endif

  if instr(temp$,"<VERB ")<>0 then
    'add a new verb to the verb$() array
    addVerb
'    print "Verb ";currentVerb
'    print "Int.   =";verb$(currentVerb,0)
'    print "synonym=";verb$(currentVerb,synonym)
'    print "action =";verb$(currentVerb,action)
    inc currentVerb
  endif

  if temp$="EOF!" then endReadLoop=1

loop while not endReadLoop

'print "Finished reading in ";totRooms;" rooms."
'print "Finished reading in ";totObjects;" objects."
'print "Finished reading in ";totVerbs;" verbs."


close #1

'now read in the routines from the actions.txt file and count them up
dim totRoutines=0

filename$="actions.txt"
open filename$ for input as #1

endReadLoop=0
do
  line input #1,temp$
  if instr(temp$,"<ROUTINE ")<>0 then inc totRoutines
  if temp$="EOF!" then endReadLoop=1
loop while not endReadLoop

close #1

dim routine$(totRoutines,30)
dim currentRoutine

open filename$ for input as #1
endreadLoop=0
do
readNewLine2:
  line input #1,temp$
  if left$(temp$,1)=";" then goto readNewLine2:
  if instr(temp$,"<ROUTINE ")<>0 then
    'add a new room to the routine$() array
    addRoutine
'    print "Added routine "; currentRoutine
'    print "Routine name  :";routine$(currentRoutine,0)
    for f=1 to 10 : print routine$(currentRoutine,f) : next f
    inc currentRoutine
  endif

  if temp$="EOF!" then endReadLoop=1

loop while not endReadLoop

'player is the object number of the player object
dim player
dim parseSuccess
player=objName2No("PLAYER")
if player=-1 then print:print "No player object found. Halting." : end


'start game

cls

dim tempObjectNo,foundVerbNo,foundObjectNo,foundIndirectNo = 0
'set endGame to 1 to finish the main game loop and end the program
dim endGame as integer = 0

'write up the introductory blather
fprint object$(player,fdesc)

fprint

dim playerLocNo,areThereExits

'start of main game loop
do

  'get the location number where the player is at
  playerLocNo=getLoc("PLAYER")

  fprint
  'if not visited this location before, display long and set visited
  if not instr(room$(playerLocNo,flags),"VISITED") then 
    fprint room$(playerLocNo,long)
    addItem("VISITED",room$(playerLocNo,flags))
  else
    fprint room$(playerLocNo,desc)
  endif


  'print up all objects visible
  for f=0 to totObjects-1
    if object$(f,0)<>"PLAYER" and object$(f,location)=object$(player,location) then
      if instr(object$(f,flags),"REMOVED") and object$(f,ldesc)<>"" then fprint object$(f,ldesc) else fprint object$(f,fdesc)
    endif
  next f

  'execute any location action that happens after entering
  'parse room$(playerLocation,action)

  'print up available exits

  areThereExits=0  
    if checkExits(playerLocNo,0) then areThereExits=1

  fprint
  if areThereExits=1 then
    fprint "There seem to be exits leading out of here:"
  else
    fprint "There do not seem to be any obvious exits out of here."
  endif

  f=checkExits(playerLocNo,1)
    
  'get an instruction from the player
getInput:
  parseSuccess=0
  fprint
  fprint "What do you do now" : input in$

  if in$="" then 
    fprint "I'm afraid you won't get very far unless you actually give me an instruction."
    goto getInput:
  endif

'............testing/debugging commands..........

  if left$(in$,4)="srf " then
    in$=stripWord("srf ",in$)
    in$=trim(in$)
    print "Flag ";in$;" set in ";room$(playerLocNo,flags)
    addItem(in$,room$(playerLocNo,flags))
    goto getInput:
  endif

  if left$(in$,4)="crf " then
    in$=stripWord("crf ",in$)
    in$=trim(in$)
    room$(playerLocNo,flags)=stripWord(in$,room$(playerLocNo,flags))
    print "Flag ";in$;" cleared from  ";room$(playerLocNo,flags)
    goto getInput:
  endif

  if left$(in$,4)="sof " then
    in$=mid$(in$,5)
    temp$=getLeftHandWord(in$)
    in$=mid$(in$,len(temp$)+2)
    print "flag ";in$;" added to ";temp$
    addItem(in$,object$(objName2No(temp$),flags))
    print object$(objName2No(temp$),flags)
    goto getInput:
  endif

  if left$(in$,4)="cof " then
    in$=mid$(in$,5)
    temp$=getLeftHandWord(in$)
    in$=mid$(in$,len(temp$)+2)
    print "flag ";in$;" cleared from ";temp$
    object$(objName2No(temp$),flags)=stripWord(in$,object$(objName2No(temp$),flags))
    print ">";object$(objName2No(temp$),flags);"<"
    goto getInput:
  endif

'.............end of testing/debugging commands............    
    

  'parse the instruction from the player

  'FIND VERB (foundVerb$)/ OBJECT(foundObject$) / INDIRECT (foundIndirect$)
  'an input must be broken down into one of three combinations
  '1. verb / object / indirect
  '2. verb / object
  '3. object
  '4. verb
  '5. none

  'NOTES:
  'there can only be an indirect if there is an object
  'if there is a verb and an object, parse the object first.
  'if there is no solution from the object, go on to parse the verb

  'first, replace all text with upper-case
  in$=ucase$(in$)

  'strip out null words
  for f=0 to 7
    in$=stripWord(nullWord$(f),in$)
  next f
  
  'parse the input for verb(s)
  foundVerbNo=-1
  temp$=in$
  getVerbNo(temp$)

  'parse the input for object(s).
  foundObjectNo=-1
  foundIndirectNo=-1

  temp$=in$
  getObjectNo(temp$)
  'sets foundObjectNo and foundIndirectNo to objects found, if present

  'if there is a direct and indirect object, parse that first
  if foundIndirectNo<>-1 then parseIndirect
  if parseSuccess then goto endOfMainLoop:
  
  'if there is a direct object but no indirect object, parse that next
  if foundObjectNo<>-1 then parseObject
  if parseSuccess then goto endOfMainLoop:

  'there could still be an indirect object and/or an object, but
  'it's not been parsed by the indirect/objects routines
  'also, there might not be an indirect object and/or an object.
  parseVerb

  'processed all options, end of parsing.  

endOfMainLoop:
loop while endGame<>1

end

sub parseIndirect
  'parse the indirect object action: object(foundIndirectNo,action)
end sub


sub parseVerb
  local routineNo
  if foundVerbNo=-1 then fprint "I'm sorry, I didn't understand that. Please try again." : goto endOfParseVerb:
  if foundVerbNo=-2 then fprint "I'm sorry, I only understand sentences with 1 verb. Please try again.": goto endOfParseVerb:
  'parse the verb action: verb(foundVerbNo,action)
  'if nothing done, give generic response

  if foundObjectNo=-1 then fprint "I'm sorry, I don't know how to do that." : goto endOfParseVerb:
  
  'get routine number from the found routine name
  routineNo=getRoutineNo(verb$(foundVerbNo,action))
  if routineNo=-1 then 
    'no routine exists for this object.
    'fail parse
    goto endOfParseVerb:
  endif

  execRoutine(routineNo)


endOfParseVerb:
end sub


sub parseObject
  local routineNo

  'start off by assuming we've not succeeded in parsing the input
  'this is a global variable
  parseSuccess=0

  'parse the direct object action: object(foundObjectNo,action),

  'check first to see if it's a direction in room$(playerLoc,exits)
  if object$(foundObjectNo,action)="EXIT" then processExit: goto endOfParseObject
  'check to see if it's present
  if object$(foundObjectNo,location)<>"NONE" and not objectPresent(foundObjectNo) goto failObject:

  'object exists in this room or in player's inventory - process its action
  'check if there's an action associated with this object
  if object$(foundObjectNo,action)="" goto endOfParseObject:

  'EXECUTE ACTION ROUTINE 

  'get routine number from the found routine name
  routineNo=getRoutineNo(object$(foundObjectNo,action))
  if routineNo=-1 then 
    'no routine exists for this object.
    'fail parse
    goto endOfParseObject:
  endif

  execRoutine(routineNo)


  goto endOfParseObject:


failObject:
    fprint "I can't see any % here.",object$(foundObjectNo,desc)
    parseSuccess=1
 
endOfParseObject:
end sub



sub execRoutine(routineNo)
  'start executing routine on line 1 (first one after the title line)
  local routineStep = 1

  'keep looping while this is 1
  local loopRoutine = 1

  'string to hold currently executing line
  local routineLine$

  'start off by assuming there is no IF, and assignments
  'need to be executed
  local conditionSuccess=1

  local invertTest, maxCarry, currentCarry

  local sizeString$,printString$,nextTest$,checkWord$,checkRoom$ = ""

runRoutine:
  'MAIN ROUTINE TEST/ASSIGNMENT EXECUTION LOOP
  'keep going round bracketed (...) until one succeeds or reach the end "<END>"
  do
    'get next line of routine to execute  
    routineLine$=routine$(routineNo,routineStep)

    if routineLine$="<END>" then
      'check if stack is empty or if need to go again
      if routineNoStack(0,0)=-1 then
        'end of stack, this <END> is the last end
        'finish loop
        loopRoutine=0
        goto endOfRoutineLoop:
      else
        'go back to the previous routine (top of stack)
        routineNo=routineNoStack(0,0)
        routineStep=routineNoStack(0,1)
        'shuffle all of stack back down one
        '(1,1 goes to 0,1 and 1,0 goes to 0,0 if it is not -1 etc etc)
        for f=0 to 9
          routineNoStack(f,0)=routineNoStack(f+1,0)
          routineNoStack(f,1)=routineNoStack(f+1,1)
        next f
        goto runRoutine:
      endif
    endif

    if left$(routineLine$,9)="(ROUTINE " then
      'shuffle all of stack up one (0,0 -> 1,0 ; 0,1 -> 1,1 etc)
      for f=10 to 1 step -1
        routineNoStack(f,0)=routineNoStack(f-1,0)
        routineNoStack(f,1)=routineNoStack(f-1,1)
      next f
      'put current routine and next step line onto top of stack
      routineNoStack(0,0)=routineNo
      routineNoStack(0,1)=routineStep+1
      'set new routine
      routineLine$=trimBrackets(mid$(routineLine$,10))
      routineNo=getRoutineNo(routineLine$)
      'routines always start at line 1 (ignore the routine title line)
      routineStep=1
      goto runRoutine:      
    endif

    'assume conditionSuccess until we see an "(IF "
    conditionSuccess=1

    if left$(routineLine$,4)="(IF " then
      'there is a condition to test before assignments
      'set conditionSuccess to 0
      conditionSuccess=0

      'strip off the "(IF " from start of line
      routineLine$=mid$(routineLine$,5)
'      print "parsing: <";routineLine$;">"
      
      do
      'loop round conditions until we hit a THEN

'      print "step ";routineStep;" of ";routine$(routineNo,0);" - <";routineLine$;">"
  '    waitkey

      'see if there's been a previous condition
        nextTest$="OR"
        if left$(routineLine$,4)="AND " then nextTest$="AND" : routineLine$=mid$(routineLine$,5)
        if left$(routineLine$,3)="OR " then routineLine$=mid$(routineLine$,4)

        'go through possible items to be tested:

        if left$(routineLine$,5)="VERB=" then
          'read which verb is to be tested
          routineLine$=mid$(routineLine$,6)
          checkWord$=getLeftHandWord(routineLine$)
'          print "checking for verb <";checkWord$;"> - >";
          'only look for a verb if the player has typed in a recognised verb
          if foundVerbNo<>-1 then
            if verb$(foundVerbNo,0)=checkword$ then
              if nextTest$="OR" then conditionSuccess=1
 '             print "FOUND"
            else
              if nextTest$="AND" then conditionSuccess=0
  '            print "NOT FOUND"
            endif
          endif
          'strip off the actual test verb
          routineLine$=mid$(routineLine$,len(checkWord$)+1)
          routineLine$=trim(routineLine$)
        endif
        'finished testing for VERB=

        if left$(routineLine$,5)="ROOM." then
          routineLine$=mid$(routineLine$,6)
          'get the name of the object to test
          checkWord$=getLeftHandWord(routineLine$)
          'strip off the object name
          routineLine$=mid$(routineLine$,len(checkWord$)+1)
          'check for = or <> , set invert and strip it off
          invertTest=0
          if left$(trim(routineLine$),1)="=" then
            routineLine$=mid$(routineLine$,2)
          else
            if left$(trim(routineLine$),2)="<>" then
              invertTest=1
              routineLine$=mid$(routineLine$,3)
            endif
          else
            print "DEBUG: no '=' or '<>' found in IF FLAGSET.";checkWord$;" in routine ";routine$(routineNo,0) : end
          endif
          'get the name of the room to test
          checkRoom$=getLeftHandWord(routineLine$)
'          print "checking if object <";checkWord$;"> is in room <";checkRoom$;"> - >";
 '         print "invert=";invert
          'strip off the checkroom
          routineLine$=mid$(routineLine$,len(checkRoom$)+1)
'          print "routineLine <";routineLine$;">"
          if checkWord$="THIS" then checkWord$=object$(foundObjectNo,0)
          if checkRoom$="ROOM.PLAYER" then checkRoom$=object$(PLAYER,location)

          if getLoc(checkWord$)=roomName2No(checkRoom$) then
            'check has passed
            if nextTest$="OR" and invertTest=0 then conditionSuccess=1 
            if nextTest$="AND" and invertTest=1 then conditionSuccess=0
 '           print "PASSED"
          else
            'check has failed
            if nextTest$="OR" and invertTest=1 then conditionSuccess=1
            if nextTest$="AND" and invertTest=0 then conditionSuccess=0
  '          print "FAILED"
          endif
          routineLine$=trim(routineLine$)
        endif
        'finished testing for ROOM.OBJECTNAME=

        if left$(routineLine$,5)="SIZE." then
          'strip off SIZE.
          routineLine$=mid$(routineLine$,6)
          'get the name of the object to test
          checkWord$=getLeftHandWord(routineLine$)
          'strip off the object name and the =
          routineLine$=mid$(routineLine$,len(checkWord$)+2)
          'get the size to test
          checkRoom$=getLeftHandWord(routineLine$)
          routineLine$=mid$(routineLine$,len(checkRoom$)+1)

          if checkWord$="THIS" then checkWord$=object$(foundObjectNo,0)
          if object$(objName2No(checkWord$),size)=checkRoom$ then
            'check has passed
            if nextTest$="OR" then conditionSuccess=1
          else
            'check has failed
            if nextTest$="AND" then conditionSuccess=0
          endif   
          routineLine$=trim(routineLine$)
        endif
        'finished testing for SIZE.OBJECTNAME

          
        if left$(routineLine$,12)="EXCEEDCARRY " then
'          print "checking for amount carried."

          sizeString$=object$(player,size)        
          maxCarry=getMaxCarry(sizeString$)
          sizeString$=object$(player,size)
          currentCarry=getCurrentCarry(sizeString$)
          if maxCarry<currentCarry+val(object$(foundObjectNo,size)) then
            'condition passed
            if nextTest$="OR" then conditionSuccess=1
          else
            'condition failed
            if nextTest$="AND" then conditionSuccess=0
          endif
        routineLine$=mid$(routineLine$,13)
        routineLine$=trim(routineLine$)
        endif
        'finished testing for EXCEEDCARRY
  
        if left$(routineLine$,8)="FLAGSET." then
          routineLine$=mid$(routineLine$,9)
          'read in which object/room is to have its flag tested
          checkWord$=getLeftHandWord(routineLine$)
          'strip off the object/room name and the =
          routineLine$=mid$(routineLine$,len(checkWord$)+2)       
          'get the name of the flag to test
          checkRoom$=getLeftHandWord(routineLine$)
'          print "checking if <";checkword$;"> has the flag <";checkRoom$;"> set >";
          if checkWord$="THIS" then checkWord$=object$(foundObjectNo,0)
          'need to work out if checkRoom$ is a room or an object
          if roomName2No(checkWord$)=-1 and objName2No(checkWord$)=-1 then print "DEBUG: object/room in FLAGSET.";checkRoom$;" doesn't exist.":end
          if roomName2No(checkWord$)<>-1 then
            'testing a room's flags:
            if checkFlags("ROOM",roomName2No(checkWord$),checkRoom$) then
            'check has passed
              if nextTest$="OR" then conditionSuccess=1 
 '             print "PASSED"
            else
              'check has failed
              if nextTest$="AND" then conditionSuccess=0
  '           print "FAILED"
            endif
          else
            'testing an object's flags:
            if checkFlags("OBJECT",objName2No(checkWord$),checkRoom$) then
              if nextTest$="OR" then conditionSuccess=1 
 '             print "PASSED"
            else
              'check has failed
              if nextTest$="AND" then conditionSuccess=0
  '           print "FAILED"
            endif
          endif
          'end of if roomName2No(checkWord$)<>-1

          'strip off the checkRoom$
          routineLine$=mid$(routineLine$,len(checkRoom$)+1)
          routineLine$=trim(routineLine$)  
        endif
        'finished testing for FLAGSET.OBJECTNAME=

       
        if left$(routineLine$,10)="FLAGUNSET." then
          routineLine$=mid$(routineLine$,11)
          'read which object/room is to have its flag tested
          checkword$=getLeftHandWord(routineLine$)
          'strip off the object/room name and the =
          routineLine$=mid$(routineLine$,len(checkword$)+2)
          'get the name of the flag to test
          checkroom$=getLeftHandWord(routineLine$)
'          print "checking if object player entered (if any) does NOT have the <";checkWord$;"> flag set >";
          if checkWord$="THIS" then checkWord$=object$(foundObjectNo,0)
          if not checkFlags("OBJECT",foundObjectNo,checkWord$)) then
            if nextTest$="OR" then conditionSuccess=1
 '           print "PASSED"
          else
  '          print "FAILED"
            if nextTest$="AND" then conditionSuccess=0
          endif
          'strip off the actual test flag
          routineLine$=mid$(routineLine$,len(checkRoom$)+1)
          routineLine$=trim(routineLine$)
        endif
        'finished testing for FLAGUNSET=

'        print "current conditionSuccess=";conditionSuccess

        'keep going round conditions until hit a THEN
        if routineLine$="" then inc routineStep : routineLine$=routine$(routineNo,routineStep)

      loop while routineLine$<>"THEN"

      inc routineStep

conditionsAllChecked:
    endif
    'end of left$(routineLine$,4)="(IF " conditions check

    'test for assignments, only do them if conditionSuccess=1
    if conditionSuccess then

'      print "Condition success. Executing assignments:"
      routineLine$=routine$(routineNo,routineStep)
      if left$(routineLine$,1)="(" then routineLine$=mid$(routineLine$,2)

      do
'        print "step ";routineStep;" of ";routine$(routineNo,0);" - <";routineLine$;">"
  '      waitkey 

        if left$(routineLine$,4)="INC." then
          routineLine$=mid$(routineLine$,5)
          'get the thing to increment
          checkWord$=getLeftHandWord(routineLine$)
          routineLine$=mid$(routineLine$,len(checkWord$)+1)
          checkRoom$=getLeftHandWord(routineLine$)
          routineLine$=mid$(routineLine$,len(checkRoom$)+1)
          if checkWord$="CARRIED" then 
            'incrementing player's carried amount
            if checkRoom$="SIZE.THIS" then checkRoom$=object$(foundObjectNo,size)

            'get player's current carried (size) string
            sizeString$=object$(player,size)
            'update current carry
            currentCarry=getCurrentCarry(sizeString$)
            currentCarry=currentCarry+val(checkRoom$)
            sizeString$=object$(player,size)
            maxCarry=getMaxCarry(sizeString$)
            object$(player,size)=str$(maxCarry)+" "+str$(currentCarry)
          else
            if checkWord$="SCORE" then
              'incrementing player's score
            endif
          else
            print "DEBUG: trying to increment unrecognised ";checkWord$;" in routine ";routine$(routineNo,0)
            end
          endif
          'all SIZE.options checked for
        endif
        'end of INC. if

        if left$(routineLine$,4)="DEC." then
          routineLine$=mid$(routineLine$,5)
          'get the thing to increment
          checkWord$=getLeftHandWord(routineLine$)
          routineLine$=mid$(routineLine$,len(checkWord$)+1)
          checkRoom$=getLeftHandWord(routineLine$)
          routineLine$=mid$(routineLine$,len(checkRoom$)+1)
          if checkWord$="CARRIED" then 
            'incrementing player's carried amount
            if checkRoom$="SIZE.THIS" then checkRoom$=object$(foundObjectNo,size)

            'get player's current carried (size) string
            sizeString$=object$(player,size)
            'update current carry
            currentCarry=getCurrentCarry(sizeString$)
            currentCarry=currentCarry-val(checkRoom$)
            sizeString$=object$(player,size)
            maxCarry=getMaxCarry(sizeString$)
            object$(player,size)=str$(maxCarry)+" "+str$(currentCarry)
          else
            if checkWord$="SCORE" then
              'incrementing player's score
            endif
          else
            print "DEBUG: trying to DEC. unrecognised ";checkWord$;" in routine ";routine$(routineNo,0)
            end
          endif
          'all SIZE.options checked for
        endif
        'end of DEC. if

        if left$(routineLine$,8)="SETFLAG." then
          routineLine$=mid$(routineLine$,9)
          'get room/object name to set flag of
          checkRoom$=getLeftHandWord(routineLine$)
          'strip it off the routine line, plus a space
          routineLine$=mid$(routineLine$,len(checkRoom$)+2)
          'get flag name to set
          checkWord$=getLeftHandWord(routineLine$)
          'check the object/room is a valid selection
          if checkRoom$="THIS" then 
            checkRoom$=object$(foundObjectNo,0)
          else           
            if roomName2No(checkRoom$)=-1 and objName2No(checkRoom$)=-1 then 
            print "DEBUG: not a valid room/object, ";checkroom$;", in SETFLAG in routine ";routine$(routineNo,0)
            end
          endif
          if roomName2No(checkRoom$)<>-1 then
            'this is a room, add the room flag
            addItem(checkWord$,room$(roomName2No(checkRoom$),flags)
'            print "setting room <";checkRoom$;"> flag, <";checkWord$;">"
          else
            'this is an object, set the object flag
            addItem(checkWord$,object$(objName2No(checkRoom$),flags))
 '           print "setting object <";checkObject;"> flag, <";checkWord$;">"
          endif
          'strip the room/object flag from the routine line, plus a space
          routineLine$=stripFirstWord(routineLine$)
        endif
        'end of SETFLAG.ROOM/OBJECT
  
        if left$(routineLine$,10)="UNSETFLAG." then
          routineLine$=mid$(routineLine$,11)
          'get room/object name to unset flag of
          checkroom$=getLeftHandWord(routineLine$)
          'strip it off, plus a space
          routineLine$=mid$(routineLine$,len(checkRoom$)+2)
          'get flag name to unset
          checkWord$=getLeftHandWord(routineLine$)
          'check the object/room is a valid selection
          if checkRoom$="THIS" then
            if foundObjectNo=-1 then print "DEBUG: trying to UNSETFLAG.THIS in ";routine$(routineNo,0);" and norecognised object typed in by player.":end
            checkRoom$=object$(foundObjectNo,0)
          else
            if roomName2No(checkRoom$)=-1 and objName2No(checkRoom$)=-1 then
              print "DEBUG: not a valid room/object, UNSETFLAG.";checkroom$;", in routine ";routine$(routineNo,0)
              end
            endif
          endif
          if roomName2No(checkRoom$)<>-1 then
            'this is a room, unset the room flag
            room$(roomName2No(checkRoom$),flags=stripWord(checkWord$,room$(roomName2No(checkRoom$),flags)
          else
            'this is an object, unset the object flag
            object$(objName2No(checkRoom$),flags)=stripWord(checkWord$,object$(objName2No(checkRoom$),flags))
          endif
          'strip the room/object flag from the routine line, plus a space
          routineLine$=stripFirstWord(routineLine$)
        endif
        'end of UNSETFLAG.ROOM/OBJECT
  
        if left$(routineLine$,8)="SETROOM." then
          routineLine$=mid$(routineLine$,9)
          'get object name to set location of
          checkWord$=getLeftHandWord(routineLine$)
          'strip it off
          routineLine$=mid$(routineLine$,len(checkWord$)+2)
          'get the room to assign it to
          checkRoom$=getLeftHandWord(routineLine$)
          'strip the room/object flag from the routine line, plus a space
          routineLine$=stripFirstWord(routineLine$)
          if checkWord$="THIS" then checkWord$=object$(foundObjectNo,0)
          if checkRoom$<>"PLAYER" then 
            if roomName2No(checkRoom$)=-1 then print "DEBUG: invalid room in SETROOM.";checkRoom$; " in routine ";routine$(routineNo,0) : end
          endif
          object$(objName2No(checkWord$),location)=checkRoom$
        endif
        'end of SETROOM.OBJECT
  
        if left$(routineLine$,4)="TELL" then
          printString$=""
          routineLine$=mid$(routineLine$,5)
          routineLine$=trim(routineLine$)
          routineLine$=mid$(routineLine$,2)
          do
            checkWord$=left$(routineLine$,1)
            if checkWord$=chr$(34) then goto endoftellLoop:
            if checkWord$="%" then checkWord$=object$(foundObjectNo,desc)
            printString$=printString$+checkWord$
            routineLine$=mid$(routineLine$,2)
          loop
endofTellLoop:

          fprint printString$

          'strip off " from end of TELL line
          routineLine$=mid$(routineLine$,2)
        endif
        'end of TELL
        

      'keep going round assignment items until hit a ")"
      if routineLine$="" then inc routineStep : routineLine$=routine$(routineNo,routineStep)

      loop while routineLine$<>")"
      'keep going round assignments until the end of this successful assignment

'      print "carried out all assignments. "

      parseSuccess=1
      goto endofParseObject:

    endif
    'end of if conditionSuccess

'    print "no successful condition parsed. moving onto next condition."

    'move onto next bracketed sub set to test
    do
      routineLine$=routine$(routineNo,routineStep)
'      print "skipping step ";routineStep;" of routine ";routine$(routineNo,0);" <";routineLine$;">"
      inc routineStep
    loop while not instr(routineLine$,")")  

endOfRoutineLoop:
  loop while loopRoutine

end sub




function getMaxCarry(size$)
  local a$
  a$=getLeftHandWord(size$)
  getMaxCarry=val(a$)
end function

function getCurrentCarry(size$)
  local a$
  a$=stripFirstWord(size$)
  getCurrentCarry=val(a$)
end function


function switch01(cond)
  local outputCond = 0
  if cond=0 then outputCond=1
  switch01=outputCond
end function

function stripFirstWord(s$) as string
  local word$
  word$=getLeftHandWord(s$)
  if len(s$)>len(word$) then
    s$=mid$(s$,len(word$)+2)
  else
    s$=""
  endif
  stripFirstWord=s$
end function


function getRoutineNo(routineName$)
  getRoutineNo=-1
  for f=0 to totRoutines-1
'    print "testing routine$(";f;",0) (";routine$(f,0);") against ";routineName$
    if routine$(f,0)=routineName$ then
'      print "success."
      getRoutineNo=f
      goto foundRoutine:
    endif
  next f
foundRoutine:
end function



function objectPresent(objNo)
  objectPresent=0
  local testFlag$  
  local objLoc
  if object$(foundObjectNo,location)="" then
    'this is a door object - has two locations (in flags)
    '-test to see if player is in either of them
    testFlag$=object$(objNo,flags)
    if not instr(testFlag$,object$(player,location)) then goto endObjectPresent:
    objectPresent=1
    goto endObjectPresent:
  endif    
  'object is not a door object - test for its location in .location
  objLoc=getLoc(object$(foundObjectNo,0))
  'if the object is in the player's inventory or current location, it is present
  if objLoc=playerLocNo or objLoc=-1 then objectPresent=1
endObjectPresent:
end function

sub processExit
  local exitString$=room$(playerLocNo,exits)
  local thisExit$,newLocation$,flagToCheck$
  local yes = 0
  'if there is no exits line, display warning and skip to end.
  if exitString$="" then
    fprint "There are no obvious exits from here."
    parseSuccess=1
    goto skipExits:
  endif
  'there is an exits line in this room, check to see
  'if object matches an exit in this room

  'loop through all the exits in exitString
  do
    'remove the "(" from the front of this exit
    exitString$=mid$(exitString$,2)

    'get first word in the string
    thisExit$=getLeftHandWord(exitString$)

    if object$(foundObjectNo,0)=thisExit$ then
      'player has typed in this exit!
      'strip off thisExit$
      exitString$=mid$(exitString$,len(thisExit$)+1)

      'check if it's a " PER " exit
      if left$(exitString$,5)=" PER " then
        processPerExit(exitString$)
        goto skipExits:
      endif

      'otherwise, it's a " TO " exit
      'strip off the " TO " at the left of the string
      exitString$=mid$(exitString$,5)
      'take the close bracket off the end
      exitString$=left$(exitString$,instr(exitString$,")")-1)

      'check to see if it's a conditional exit
      if instr(exitString$," IF ") then
        'store the new location
        newLocation$=getLeftHandWord(exitString$)
        'strip off the new location and the " IF "
        exitString$=mid$(exitString$,len(newLocation$)+5)
        'get the flag that we're checking for
        flagToCheck$=getLeftHandWord(exitString$)
        'check the flags in this room to see if the flag above has been set
        yes=checkFlags("ROOM",playerLocNo,flagToCheck$)
        if yes then goto assignNewLocation:
        'check to see if there's an ELSE
        exitString$=mid$(exitString$,len(flagToCheck$)+2)
        if left$(exitString$,5)<>"ELSE " then goto skipExits:
        'strip off the "ELSE "
        exitString$=mid$(exitString$,6)

        'check to see if there's something to display'
        if left$(exitString$,1)="'" then 
          exitString$=mid$(exitString$,2)
          fprint left$(exitString$,len(exitString$)-1)
        endif
        '.... could there be other options after an ELSE?
        '.... at the moment, it can only display a string
        '..........done " PER " and " TO " exits...
        '....more code here for other options?
        parseSuccess=1
        goto skipExits:

      else
        'there is no condition,
        'assign new location unconditionally
        newLocation$=exitString$
        parseSuccess=1
      endif

assignNewLocation:      
      object$(player,location)=newlocation$
      fprint : fprint "You go %.",object$(foundObjectNo,desc)
      parseSuccess=1
      goto skipExits: 
    endif
    'move on to the next exit
    exitString$=trimFirstItem(exitString$)

  loop while exitString$<>""
  'if execution reaches here, no exit has been found
  'in the room that matches the player's input
  fprint "There is no exit in that direction."
  parseSuccess=1
skipExits:
end sub


sub processPerExit(exitString$)
  local newLocation$
  'strip the ")" off the end of the exitString
  exitString$=trimBrackets(exitString$)
  exitString$=mid$(exitString$,len(" PER ")+1)
  'process the object in exitString$ to find out whether player can move or not
  foundObjectNo=objName2No(exitString$)
  if foundObjectNo=-1 then print "DEBUG: not a valid object found in processPerExit.":end
  if checkFlags("OBJECT",foundObjectNo,"LOCKED")=1 then
    fprint "You can't go that way, the % is locked.",object$(foundObjectNo,desc)
    parseSuccess=1
    goto endProcessPerExit:
  endif
  if checkFlags("OBJECT",foundObjectNo,"OPEN")=0 then
    fprint "You can't go that way, the % is closed.",object$(foundObjectNo,desc)
    parseSuccess=1
    goto endProcessPerExit:
  endif
  'read in which locations the object connects from flags
  'if the player is in one, set object$(player,location) to the other
  'and vice versa
  newLocation$=getRoomFromFlags(foundObjectNo)
  if newLocation$="" then print "DEBUG: no destination room found in door object ";object$(foundObjectNo,0):end
  object$(player,location)=newLocation$
  parseSuccess=1
  
endProcessPerExit:
end sub

'this function is used to find room names in the flags string
'of "door" objects
function getRoomFromFlags(objNo) as string
  local destRoom1$,destRoom2$ = ""
  local flagString$ = object$(objNo,flags)
  local f
  for f=0 to totRooms-1
    if instr(flagString$,room$(f,0)) and destRoom1$="" then
      destRoom1$=room$(f,0)
      flagString$=stripWord(room$(f,0),flagString$)
    endif
    if instr(flagString$,room$(f,0)) then
      destRoom2$=room$(f,0)
      goto endOfGetRoomFor:
    endif
  next f
endOfGetRoomFor:
 'choose which destination room to assign
  'as player's new location
  if destRoom1$=object$(player,location) then
    getRoomFromFlags=destRoom2$
  else
    getRoomFromFlags=destRoom1$
  endif
end function
    
function checkExits(roomNo,printOn)
  local areThereExits,objectNo = 0
  local roomExits$ = room$(roomNo,exits)
  local checkExit$,whichExit$,exitType$
  'check the exits in room number roomNo, write them up if printOnOff
  do
    checkExit$=getNextItem(roomExits$)
    checkExit$=trimBrackets(checkExit$)
    whichExit$=getLeftHandWord(checkExit$)
    checkExit$=mid$(checkExit$,len(whichExit$)+1)
    if left$(checkExit$,4)=" TO " then
      'normal exit, print it up if printOn
      areThereExits = 1
      getObjectNo(whichExit$)
      if printOn then fprint "%",object$(foundObjectNo,desc)
    endif

    'finished processing this exit, 
    'trim it off roomExits$ and move to next
    roomExits$=trimFirstItem(roomExits$)
  loop while roomExits$<>""

  checkExits=areThereExits
end function


function objName2No(o$)
  objName2No=-1
  local f
  for f=0 to totObjects-1
    if object$(f,0)=o$ then objName2No=f  
  next f
end function

function roomName2No(r$)
  roomName2No=-1
  local f
  for f=0 to totRooms-1
    if room$(f,0)=r$ then roomName2No=f
  next f
end function


function trimBrackets(s$) as string
  if left$(s$,1)="(" then s$=mid$(s$,2) 
  if right$(s$,1)=")" then s$=left$(s$,len(s$)-1)
  trimBrackets=s$
end function


function checkFlags(type$,number,flag$)
  checkFlags=0
  if type$<>"ROOM" and type$<>"OBJECT" then print "DEBUG: checkFlags called with wrong type (not ROOM or OBJECT).":end
  if type$="ROOM" then
    if instr(room$(number,flags),flag$) then checkFlags=1
  else
    'type$ must be OBJECT
    if instr(object$(number,flags),flag$) then checkFlags=1
  endif

endOfCheckFlags:    
end function


'getNextItem returns the left hand portion of s$
'up to and including the first ")"
'returns s$ if there is no ")"
function getNextItem(s$) as string
  local splitPoint=instr(s$,")")
  if splitPoint<>0 then
    getNextItem=left$(s$,splitPoint)
  else
    getNextItem=s$
  endif
end function


'trimFirstItem trims the left hand end of the string,
'up to (but not including), the next "(" character
'if there isn't another "(", it returns and empty string
function trimFirstItem(s$) as string
  local splitPoint=instr(2,s$,"(")
  if splitPoint=0 then 
    trimFirstItem=""
  else
    trimFirstItem=mid$(s$,splitPoint)
  endif
end function


'getLeftHandWord returns the first word of the string,
'up to but not including the first space, "=", ">", "<", "-" or "+"
'or the entire string, if there are no spaces in it.
function getLeftHandWord(s$) as string
  local test$=trim(s$)
  local f$=""
  local output$=""
  do
    f$=left$(test$,1)
    if f$<>" " and f$<>"=" and f$<>">" and f$<>"<" and f$<>"-" and f$<>"+" then
      output$=output$+f$
      test$=mid$(test$,2)
    else
      goto endLeftHandFunction:
    endif
  loop while test$<>""

endLeftHandFunction:

  getLeftHandWord=output$
end function

'getVerbNo() returns the verb number of the verb found in the input
'if there is no verb, it sets foundVerbNo to -1
'if there is more than one verb, it sets foundVerbNo to -2
sub getVerbNo(i$)
  local f
  local splitPoint
  local word$, remain$
  local found=-1

  'add spaces to front and back of input
  i$=" "+i$+" "

  for f=0 to totVerbs-1 
  remain$=verb$(f,synonym)

    do
      'take the next leftmost word of synonym 
      splitPoint=instr(remain$," ")
      if splitPoint<>0 then
        word$=left$(remain$,splitPoint-1)
        remain$=mid$(remain$,splitPoint+1)
      else 
        word$=remain$
        remain$=""
      endif
  
      word$=" "+word$+" "
      'search input for this synonym
      if instr(i$,word$) then
        if found<>-1 then found=-2 else found=f
        goto breakdoloop:
        'break out of do-loop - synonym found, no need to look for more
      endif

    loop while remain$<>""
    'loop until all synonyms of this verb have been checked

breakdoloop:    
  'move onto the next verb to check
  next f

  foundVerbNo=found
end sub

'this subroutine looks for up to two objects.
'if there are no objects, it assigns foundObjectNo = -1
'if there is only one, it assigns foundObjectNo to the object numbers
'if there are two, it assigns foundIndirectNo and foundObject No both to object numbers
sub getObjectNo(i$)
  local f,splitPoint,foundPos,tempf
  local word$,remain$
  local found = -1

  'add spaces to front and back of input
  i$=" "+i$+" "

  for f=0 to totObjects-1
  remain$=object$(f,synonym)

  do
    'take the next leftmost word of synonym
    splitPoint=instr(remain$," ")
    if splitPoint<>0 then
      word$=left$(remain$,splitPoint-1)
      remain$=mid$(remain$,splitPoint+1)
    else
      word$=remain$
      remain$=""
    endif

    word$=" "+word$+" "
    'search input for this synonym
    foundPos=instr(i$,word$)
    if foundPos<>0 then
      'object synonym found in input
      if found=-1 then
        'this is the first object found in input
        found=foundPos
        foundObjectNo=f
      else
        'this is the 2nd..3rd...4th...object found in input
        if foundPos>found then 
          'this object occurs later in the string than the previous one
          'so it is the indirect object
          foundIndirectNo=f
        else
          'this object occurs earlier in the string than the previous one
          'so this one is the object, the previous is the indirect
          tempf=foundObjectNo
          foundObjectNo=f
          foundIndirectNo=tempf
        endif
        'end of foundPos>found
      endif
      'end of if found=-1

    goto breakobjdoloop:
    'object synonym has been found - no need to check more
    endif
    'end of if foundPos<>0
 
    loop while remain$<>""
    'loop until all synonyms of this object have been checked

breakobjdoloop:    
  'move onto the next object to check
  next f

end sub


'this function returns the room number of the object with internal name obj$
function getLoc(obj$) as integer
  local l,f
  for l=0 to totObjects-1
    'look up the object with internal name obj$
    if object$(l,0)=obj$ then
      if object$(l,location)="PLAYER" then getLoc=-1 : goto loclookupbreakout:
      for f=0 to totRooms-1
        'look up the room with internal name as object's location
        if room$(f,0)=object$(l,location) then getLoc=f : goto loclookupbreakout:
      next f
    print "DEBUG: Object ";obj$;" has been assigned a location that doesn't exist (";object$(l,location)
    end
    endif
  next l
loclookupbreakout:
end function

sub addItem(item$,mainstring$)
  local addBracket=0
  'take ) off the end of the string
  if right$(mainstring$,1)=")" then mainstring$=left$(mainstring$,len(mainstring$)-1) : addBracket=1
  'add the item
  mainstring$=mainstring$+" "+item$
  if addBracket=1 then mainstring$=mainstring$+")"
end sub
  

sub addRoom
  local exitcont,endLoop = 0
  'assign the internal name
  room$(currentRoom,0)= right$(temp$,len(temp$)-6)
  do 
skip:
    line input#1,temp$
    temp$=trim(temp$)    
    'check for commented out line
    if left$(temp$,1)=";" or temp$="" then goto skip:

    'check for syntax error
    if left$(temp$,1)="<" then print "DEBUG: no '>' syntax error in room ";room$(currentRoom,0) : end
    'check for end of loop
    if right$(temp$,1)=">" then endLoop=1 : temp$=left$(temp$,len(temp$)-1)
    'check for exits
    if instr(temp$," TO ") or instr(temp$," PER ") or exitcont=1 then
      if room$(currentRoom,exits)="" then
        room$(currentRoom,exits)=temp$
      else
        room$(currentRoom,exits)=room$(currentRoom,exits)+" "+temp$
      endif
      exitcont=1
      if instr(temp$,")")<>0 then exitcont=0
    endif
    'check for action
     if instr(temp$,"(ACTION ") then temp$=mid$(temp$,9) : room$(currentRoom,action)=left$(temp$,len(temp$)-1)
    'check for flags
    if instr(temp$,"(FLAGS ") then temp$=right$(temp$,len(temp$)-7) : room$(currentRoom,flags)=left$(temp$,len(temp$)-1)  
    'check for verbose
    if instr(temp$,"(FDESC ") then temp$=mid$(temp$,9) : room$(currentRoom,long)=left$(temp$,len(temp$)-2)
    'check for desc
    if instr(temp$,"(DESC ") then temp$=right$(temp$,len(temp$)-7): room$(currentRoom,desc)=left$(temp$,len(temp$)-2)
   
  loop while not endLoop
end sub

sub addObject
  local endLoop = 0
  'assign the internal name
  object$(currentObject,0)= right$(temp$,len(temp$)-8)
  do
skipobj:
    line input#1,temp$
    temp$=trim(temp$)    
    'check for commented out line
    if left$(temp$,1)=";" or temp$="" then goto skipobj:

    'check for syntax error
    if left$(temp$,1)="<") then print "DEBUG: no '>' syntax error in object ";object$(currentObject,0) : end
    'check for end of loop
    if right$(temp$,1)=">" then endloop=1 : temp$=left$(temp$,len(temp$)-1)
    'check for desc
    if instr(temp$,"(DESC ") then temp$=right$(temp$,len(temp$)-7) : object$(currentObject,desc)=left$(temp$,len(temp$)-2)
    'check for fdesc
    if instr(temp$,"(FDESC ") then temp$=right$(temp$,len(temp$)-8) : object$(currentObject,fdesc)=left$(temp$,len(temp$)-2)
    'check for ldesc
    if instr(temp$,"(LDESC ") then temp$=right$(temp$,len(temp$)-8) : object$(currentObject,ldesc)=left$(temp$,len(temp$)-2)
    'check for location
    if instr(temp$,"(LOC ") then temp$=right$(temp$,len(temp$)-5) : object$(currentObject,location)=left$(temp$,len(temp$)-1)    
    'check for synonyms
    if instr(temp$,"(SYNONYM ") then temp$=right$(temp$,len(temp$)-9) : object$(currentObject,synonym)=left$(temp$,len(temp$)-1)
    'check for adjectives
    if instr(temp$,"(ADJECTIVE ") then temp$=right$(temp$,len(temp$)-11) : object$(currentObject,adjective)=left$(temp$,len(temp$)-1)
    'check for size
    if instr(temp$,"(SIZE ") then temp$=right$(temp$,len(temp$)-6) : object$(currentObject,size)=left$(temp$,len(temp$)-1)
    'check for action
    if instr(temp$,"(ACTION ") then temp$=mid$(temp$,9) : object$(currentObject,action)=left$(temp$,len(temp$)-1)
    'check for flags
    if instr(temp$,"(FLAGS ") then temp$=mid$(temp$,8) : object$(currentObject,flags)=left$(temp$,len(temp$)-1)
    
  loop while not endloop
end sub
    
sub addVerb
  local endLoop,actioncont
  endloop=0
  'assign the internal name
  verb$(currentVerb,0)= right$(temp$,len(temp$)-6)
  do
nextverb:
    line input #1,temp$
    temp$=trim(temp$)
    'check for comment out line
    if left$(temp$,1)=";" or temp$="" then goto nextverb:
    'check for syntax error
    if left$(temp$,1)="<") then print "DEBUG: no '>' syntax error in verb ";verb$(currentVerb,0) : end
    'check for end of loop
    if right$(temp$,1)=">" then endloop=1 : temp$=left$(temp$,len(temp$)-1)
    'check for synonyms
    if instr(temp$,"(SYNONYM ") then temp$=right$(temp$,len(temp$)-9) : verb$(currentVerb,synonym)=left$(temp$,len(temp$)-1)
    'check for action
    if instr(temp$,"(ACTION ") or actioncont=1 then
      if instr(temp$,"(ACTION ") then
        verb$(currentVerb,action)=mid$(temp$,9)
      else
        verb$(currentVerb,action)=verb$(currentVerb,action)+" "+temp$
      endif
      actioncont=1
      if instr(temp$,")")<>0 then actioncont=0 : verb$(currentVerb,action)=left$(verb$(currentVerb,action),len(verb$(currentVerb,action))-1)
    endif
    
  loop while not endloop
end sub

sub addRoutine
  local endLoop,routineLine = 1
  routine$(currentRoutine,0)=mid$(temp$,10)
  do
nextRoutine:
    line input #1,temp$
    temp$=trim(temp$)
    'check for comment out line
    if left$(temp$,1)=";" or temp$="" then goto nextRoutine:
    'check for syntax error
    if left$(temp$,1)="<") then print "DEBUG: no '>' syntax error in routine ";routine$(currentRoutine,0):end
    'check for end of loop
    if right$(temp$,1)=">" then endloop=1: temp$=left$(temp$,len(temp$)-1)
    'add the line
    routine$(currentRoutine,routineLine)=temp$
    inc routineLine
  loop while not endloop
  routine$(currentRoutine,routineLine)="<END>"
end sub
    
function trim(s$) as string
  do while left$(s$,1)=" "
    s$=right$(s$,len(s$)-1)
  loop
  do while right$(s$,1)=" "
    s$=left$(s$,len(s$)-1)
  loop
  trim=s$
end function

'stripWord strips out ALL occurences of word$ in the string sentence$
function stripWord(word$,sentence$) as string
'  print "in stripWord, trying to strip <";word$;"> from <";sentence$;">"
  local splitPoint, addBracket as integer
  local l$
  local r$
  if right$(sentence$,1)=")" then 
    addBracket=1:sentence$=left$(sentence$,len(sentence$)-1)
'    print "taken ) off end."
  else
'    print "no ) taken off end."
  endif

  if left$(word$,1)<>" " then word$=" "+word$
  if right$(word$,1)<>" " then word$=word$+" "
  sentence$=" "+sentence$+" "
  do
    'remove the word "word$" from the string "sentence$" and close up spaces if nec
    splitPoint = instr(sentence$,word$)
    if splitPoint<>0 then
      l$=left$(sentence$,splitPoint-1)
      r$=mid$(sentence$,splitPoint+len(word$))

      sentence$=trim(l$)+" "+trim(r$)
      sentence$=" "+sentence$+" "
    endif
  loop while instr(sentence$,word$)

  sentence$=trim(sentence$)
  word$=trim(word$)

  if addBracket=1 then sentence$=sentence$+")"

'  print "end of stripword: sentence$ <";sentence$;">"

  stripWord=sentence$
  
end function




'fprint scrolls the screen and prints the string s$ at the bottom of the page,
'word-wrapped, one line at a time.
'it also inserts the second string (if present) into the first string a the "%" char
sub fprint(st$,insert$)
  'f steps through the string from char 1 to the end
  local f =1
  'ch$ is the current character
  local ch$ as string
  'word$ is the last full word
  local word$ as string
  local st1$,st2$ as string

  local cursorX =0
  local posi as integer

  if st$="" then scroll1line : goto end_of_fprint:

  'put the inserted word in, if there is one
  if insert$<>"" then
    posi=instr(st$,"%")
    st1$=left$(st$,posi-1)
    st2$=right$(st$,len(st$)-posi)
    st$=st1$+insert$+st2$
  endif

  scroll1line

scanString:
  ch$=mid$(st$,f,1)

  'read in a full word from st$
  do while ch$<>" "
    word$=word$+ch$
    if f=len(st$) then goto break:
    f=f+1
    ch$=mid$(st$,f,1)
  loop

break:

  if cursorX+len(word$)>lineLen then scroll1line:cursorX=0
  text cursorX*fw, bottomrow, word$
  cursorX=cursorX+len(word$)+1
  word$=""
  f=f+1
  if f<len(st$) then goto scanString:

end_of_fprint:
end sub  
'end of fprint()


sub scroll1line
  local f as integer
  local scrollSpeed=4
  for f=1 to (fh/scrollSpeed)
    blit 0,scrollSpeed,0,0,mm.hres,mm.vres-scrollSpeed
    box 0,bottomrow+fh-scrollSpeed,mm.hres,scrollSpeed,0,0,rgb(black)
  next f
end sub

sub waitkey
  do while inkey$<>""
  loop
  do while inkey$=""
  loop
end sub